/*
 * Copyright (c) 2002-2007 TeamDev Ltd. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * The complete licence text can be found at
 * http://www.teamdev.com/winpack/license.jsf
 */
package teamdev.jxcapture.samples.demo;

import org.jdesktop.application.Action;
import org.jdesktop.application.*;

import javax.swing.*;
import javax.swing.plaf.BorderUIResource;
import java.awt.*;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

/**
 * @author Ikryanov Vladimir
 */
public class AboutDialog extends EscapeDialog {

    private static AboutDialog instance;

    private HTMLLabel companyLink;
    private ResourceMap resourceMap;

    private AboutDialog() {
        ApplicationContext context = Application.getInstance().getContext();
        resourceMap = context.getResourceMap(AboutDialog.class);

        setName("dialog");

        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add(createContentPane(), BorderLayout.CENTER);
        contentPane.add(createActionPane(), BorderLayout.SOUTH);
        setContentPane(contentPane);
        setSize(424, 360);
        setPreferredSize(new Dimension(getSize()));
        setLocationRelativeTo(null);
        setResizable(false);
        setModal(true);

        resourceMap.injectComponents(this);
    }

    public static AboutDialog getInstance() {
        return instance == null ? instance = new AboutDialog() : instance;
    }

    private Component createActionPane() {
        ApplicationContext context = Application.getInstance().getContext();
        ApplicationActionMap actionMap = context.getActionMap(AboutDialog.class, this);
        JButton okButton = new JButton(actionMap.get("close"));
        okButton.setPreferredSize(new Dimension(75, 23));

        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.add(new JSeparator(), new GridBagConstraints(
                0, 0, 2, 1, 1.0, 0.0, GridBagConstraints.NORTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add(Box.createHorizontalGlue(), new GridBagConstraints(
                0, 1, 1, 1, 1.0, 0.0, GridBagConstraints.NORTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add(okButton, new GridBagConstraints(
                1, 1, 1, 1, 0.0, 0.0, GridBagConstraints.NORTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(8, 8, 8, 8), 0, 0));
        return contentPane;
    }

    private Component createContentPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.add(createLogoPane(), BorderLayout.WEST);
        contentPane.add(createInfoPane(), BorderLayout.CENTER);
        return contentPane;
    }

    private Component createLogoPane() {
        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setBackground(Color.WHITE);
        contentPane.setBorder(new BorderUIResource.EmptyBorderUIResource(4, 4, 4, 4));
        JLabel about = new JLabel();
        about.setName("about");
        contentPane.add(about, BorderLayout.CENTER);
        return contentPane;
    }

    private Component createInfoPane() {
        JLabel copyrightCompany = new JLabel();
        JLabel copyrightProduct = new JLabel();
        copyrightCompany.setName("company");
        copyrightProduct.setName("product");

        companyLink = new HTMLLabel(
                resourceMap.getString("CompanyLink.text"),
                resourceMap.getString("CompanyLink.url"));
        companyLink.setToolTipText(resourceMap.getString("CompanyLink.url"));

        HTMLLabel libraryLink = new HTMLLabel(
                resourceMap.getString("SwingApplicationFramework.text"),
                resourceMap.getString("SwingApplicationFramework.url"));
        libraryLink.setToolTipText(resourceMap.getString("SwingApplicationFramework.url"));

        JPanel contentPane = new JPanel(new GridBagLayout());
        contentPane.setBorder(new BorderUIResource.EmptyBorderUIResource(4, 4, 4, 4));
        contentPane.setBackground(Color.WHITE);
        contentPane.add(createProductNamePane(), new GridBagConstraints(
                0, 0, 2, 1, 1.0, 0.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.SOUTH, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add(Box.createVerticalGlue(), new GridBagConstraints(
                0, 1, 2, 1, 0.0, 1.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.SOUTH, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add(companyLink, new GridBagConstraints(
                0, 2, 2, 1, 1.0, 0.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(0, 4, 4, 0), 0, 0));
        contentPane.add(copyrightCompany, new GridBagConstraints(
                0, 6, 2, 1, 1.0, 0.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(4, 4, 0, 0), 0, 0));
        contentPane.add(copyrightProduct, new GridBagConstraints(
                0, 7, 2, 1, 1.0, 0.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(0, 4, 0, 0), 0, 0));
        contentPane.add(new JLabel(resourceMap.getString("note.text1")), new GridBagConstraints(
                0, 3, 2, 1, 1.0, 0.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(10, 4, 0, 0), 0, 0));
        contentPane.add(libraryLink, new GridBagConstraints(
                0, 4, 1, 1, 0.0, 0.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(0, 4, 0, 0), 0, 0));
        contentPane.add(new JLabel(resourceMap.getString("note.text2")), new GridBagConstraints(
                1, 4, 1, 1, 0.0, 0.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(0, 4, 0, 0), 0, 0));
        contentPane.add(new JLabel(resourceMap.getString("note.text3")), new GridBagConstraints(
                0, 5, 2, 1, 1.0, 0.0, GridBagConstraints.SOUTHWEST,
                GridBagConstraints.HORIZONTAL, new Insets(0, 4, 10, 0), 0, 0));
        return contentPane;
    }

    private Component createProductNamePane() {
        JLabel logo = new JLabel();
        logo.setName("logotype");

        JLabel version = new JLabel();
        version.setName("version");
        version.setForeground(Color.GRAY);
        version.setBorder(new BorderUIResource.EmptyBorderUIResource(0, 112, 0, 0));

        JPanel contentPane = new JPanel(new BorderLayout());
        contentPane.setOpaque(false);
        contentPane.setBorder(new BorderUIResource.EmptyBorderUIResource(15, 0, 0, 0));
        contentPane.add(logo, BorderLayout.WEST);
        contentPane.add(version, BorderLayout.SOUTH);
        return contentPane;
    }

    @Action
    public void close() {
        companyLink.dispose();
        setVisible(false);
        dispose();
    }

    public class HTMLLabel extends JLabel {

        private String url;

        private Color mouseEnteredColor;
        private Color mouseExitedColor;

        private boolean mouseEntered;

        private HTMLLabelMouseListener mouseListener = new HTMLLabelMouseListener();

        public HTMLLabel(String text, String url) {
            this(text, url, Color.BLUE, Color.BLUE);
        }

        public HTMLLabel(String text, String url, Color mouseEnteredColor, Color mouseExitedColor) {
            this.url = url;
            this.mouseEnteredColor = mouseEnteredColor;
            this.mouseExitedColor = mouseExitedColor;

            setText(text);
            setCursor(new Cursor(Cursor.HAND_CURSOR));
            setForeground(mouseExitedColor);

            addMouseListener(mouseListener);
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (isEnabled() && mouseEntered) {
                g.drawLine(0, getHeight() - 1, (int) getPreferredSize().getWidth(), getHeight() - 1);
            }
        }

        public void dispose() {
            removeMouseListener(mouseListener);
        }

        private class HTMLLabelMouseListener extends MouseAdapter {

            public void mouseClicked(MouseEvent event) {
                try {
                    Runtime.getRuntime().exec("cmd /c start " + url);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }

            public void mouseEntered(MouseEvent e) {
                setForeground(mouseEnteredColor);
                mouseEntered = true;
                repaint();
            }

            public void mouseExited(MouseEvent e) {
                setForeground(mouseExitedColor);
                mouseEntered = false;
                repaint();
            }
        }
    }
}
